#ifndef OSABSTRACTION_H
#define OSABSTRACTION_H

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

#ifdef USE_DIRECT_OS
#include <stdio.h>
#include <memory.h>
#include <string.h>
typedef FILE* FileHandle;
#define INVALID_FILE_HANDLE ((FileHandle)NULL)
#else
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
typedef OSAL_tIODescriptor FileHandle;
#define INVALID_FILE_HANDLE ((FileHandle)OSAL_ERROR)
#endif

bool fileClose(FileHandle fh);
FileHandle fileOpenReadOnly(const char* name);
FileHandle fileOpenWriteOnly(const char* name);
bool removeFile(const char* name);
size_t writeFile(const void *buffer, size_t size, size_t count, FileHandle stream);
void* copyMemory(void *dest, const void *src, size_t count);
void* setMemory(void *dest, int c, size_t count);
size_t readFile(void *buffer, size_t size, size_t count, FileHandle stream);
size_t getFileSize(FileHandle stream);

#endif // OSABSTRACTION_H
